/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.usermgmt.enumeration.AuthenticationStatus;
import gov.va.med.mhv.usermgmt.transfer.InPersonAuthentication;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public final class InPersonAuthenticationStatusUtils {
    
    public static final AuthenticationStatus UNAUTHENTICATED = 
        AuthenticationStatus.getEnum(AuthenticationStatus.UNAUTHENTICATED);

    public static final AuthenticationStatus AUTHENTICATED  = 
        AuthenticationStatus.getEnum(AuthenticationStatus.AUTHENTICATED);

    public static final AuthenticationStatus PENDING_AUTHENTICATION = 
        AuthenticationStatus.getEnum(AuthenticationStatus.
            PENDINGAUTHENTICATION);

    public static final AuthenticationStatus PENDING_REMOVAL = 
        AuthenticationStatus.getEnum(AuthenticationStatus.
        PENDINGREMOVAL);

    public static final AuthenticationStatus PENDING_DATA_MISMATCH = 
        AuthenticationStatus.getEnum(AuthenticationStatus.
        PENDINGDATAMISMATCH);

    public static final AuthenticationStatus PENDING_FAILED = 
        AuthenticationStatus.getEnum(AuthenticationStatus.
        PENDINGFAILED);

    public static final AuthenticationStatus REMOVAL_FAILED = 
        AuthenticationStatus.getEnum(AuthenticationStatus.
        REMOVALFAILED);
    
    public static final AuthenticationStatus INPROCESS = 
        AuthenticationStatus.getEnum(AuthenticationStatus.
            INPROCESS);

    public static final AuthenticationStatus PREREQUISITES_COMPLETE = 
        AuthenticationStatus.getEnum(AuthenticationStatus.
            PREREQUISITESCOMPLETE);

    public static boolean isUnauthenticated(InPersonAuthentication ipa) {
        Precondition.assertNotNull("ipa", ipa);
        return UNAUTHENTICATED.equals(ipa.getStatus());
    }

    public static boolean isUnauthenticated(AuthenticationStatus status) {
        return (status != null) && UNAUTHENTICATED.equals(status);
    }

    public static boolean isAuthenticated(InPersonAuthentication ipa) {
        Precondition.assertNotNull("ipa", ipa);
        return AUTHENTICATED.equals(ipa.getStatus());
    }

    public static boolean isAuthenticated(AuthenticationStatus status) {
        return (status != null) && AUTHENTICATED.equals(status);
    }

    public static boolean isPendingAuthentication(InPersonAuthentication ipa) {
        Precondition.assertNotNull("ipa", ipa);
        return PENDING_AUTHENTICATION.equals(ipa.getStatus());
    }

    public static boolean isPendingAuthentication(AuthenticationStatus status) {
        return (status != null) && PENDING_AUTHENTICATION.equals(status);
    }

    public static boolean isPendingRemoval(InPersonAuthentication ipa) {
        Precondition.assertNotNull("ipa", ipa);
        return PENDING_REMOVAL.equals(ipa.getStatus());
    }

    public static boolean isPendingRemoval(AuthenticationStatus status) {
        return (status != null) && PENDING_REMOVAL.equals(status);
    }

    public static boolean isPendingDataMismatch(InPersonAuthentication ipa) {
        Precondition.assertNotNull("ipa", ipa);
        return PENDING_DATA_MISMATCH.equals(ipa.getStatus());
    }

    public static boolean isPendingDataMismatch(AuthenticationStatus status) {
        return (status != null) && PENDING_DATA_MISMATCH.equals(status);
    }
    
    public static boolean isPendingFailure(InPersonAuthentication ipa) {
        Precondition.assertNotNull("ipa", ipa);
        return PENDING_FAILED.equals(ipa.getStatus());
    }

    public static boolean isPendingFailure(AuthenticationStatus status) {
        return (status != null) && PENDING_FAILED.equals(status);
    }

    public static boolean isRemovalFailed(InPersonAuthentication ipa) {
        Precondition.assertNotNull("ipa", ipa);
        return REMOVAL_FAILED.equals(ipa.getStatus());
    }

    public static boolean isRemovalFailed(AuthenticationStatus status) {
        return (status != null) && REMOVAL_FAILED.equals(status);
    }

    public static boolean isInProcess(InPersonAuthentication ipa) {
        Precondition.assertNotNull("ipa", ipa);
        return INPROCESS.equals(ipa.getStatus());
    }

    public static boolean isInProcess(AuthenticationStatus status) {
        return (status != null) && INPROCESS.equals(status);
    }

    public static boolean isPreRequisitesComplete(InPersonAuthentication ipa) {
        Precondition.assertNotNull("ipa", ipa);
        return PREREQUISITES_COMPLETE.equals(ipa.getStatus());
    }

    public static boolean isPreRequisitesComplete(AuthenticationStatus status) {
        return (status != null) && PREREQUISITES_COMPLETE.equals(status);
    }

    private InPersonAuthenticationStatusUtils() {
    }

}
